<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Premium Service Hub</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #3f37c9;
            --accent: #4895ef;
            --dark: #1f2937;
            --light: #f8f9fa;
            --success: #4cc9f0;
            --warning: #f8961e;
            --danger: #f72585;
            --gray: #6b7280;
            --light-gray: #e5e7eb;
        }

        /* Base Styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
            color: var(--dark);
            line-height: 1.6;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            background-color: white;
            border-radius: 16px;
            box-shadow: 0 12px 30px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 1200px;
            overflow: hidden;
            position: relative;
        }

        /* Header Styles */
        header {
            text-align: center;
            padding: 40px 20px 30px;
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            color: white;
            position: relative;
        }

        h1 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 15px;
            letter-spacing: -0.5px;
        }

        .tagline {
            font-size: 1.1rem;
            max-width: 700px;
            margin: 0 auto 25px;
            opacity: 0.9;
            font-weight: 300;
        }

        /* Enhanced Three-dot Menu */
        .menu-container {
            position: absolute;
            top: 25px;
            left: 25px;
            z-index: 100;
        }

        .menu-toggle {
            width: 44px;
            height: 44px;
            border-radius: 50%;
            background-color: rgba(255, 255, 255, 0.2);
            display: flex;
            justify-content: center;
            align-items: center;
            cursor: pointer;
            transition: all 0.3s ease;
            backdrop-filter: blur(5px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .menu-toggle:hover {
            background-color: rgba(255, 255, 255, 0.3);
            transform: rotate(90deg);
        }

        .menu-toggle i {
            font-size: 1.5rem;
            color: white;
        }

        .dropdown-menu {
            display: none;
            position: absolute;
            top: 60px;
            left: 0;
            background-color: white;
            border-radius: 12px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
            width: 240px;
            overflow: hidden;
            z-index: 99;
            animation: fadeIn 0.3s ease;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .dropdown-menu a {
            display: flex;
            align-items: center;
            padding: 15px 20px;
            color: var(--dark);
            text-decoration: none;
            font-weight: 500;
            transition: all 0.2s ease;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        }

        .dropdown-menu a:last-child {
            border-bottom: none;
        }

        .dropdown-menu a:hover {
            background-color: #f8f9fa;
            color: var(--primary);
            padding-left: 25px;
        }

        .dropdown-menu a i {
            margin-right: 12px;
            width: 20px;
            text-align: center;
            color: var(--primary);
        }

        /* Features Section */
        .feature-showcase {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 25px;
            padding: 40px;
            background-color: white;
        }

        .feature-box {
            background: linear-gradient(135deg, #ffffff 0%, #f9fafb 100%);
            border-radius: 12px;
            padding: 30px;
            text-align: center;
            transition: all 0.3s ease;
            border: 1px solid rgba(0, 0, 0, 0.05);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.03);
        }

        .feature-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(67, 97, 238, 0.1);
            border-color: rgba(67, 97, 238, 0.2);
        }

        .feature-icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, var(--primary) 0%, var(--accent) 100%);
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 0 auto 20px;
            color: white;
            font-size: 1.8rem;
            box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
        }

        .feature-box h3 {
            font-size: 1.3rem;
            margin-bottom: 15px;
            color: var(--dark);
            font-weight: 600;
        }

        .feature-box p {
            color: var(--gray);
            font-size: 0.95rem;
            line-height: 1.6;
        }

        /* Pricing Section */
        .documentation-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            padding: 0 40px 40px;
        }

        .documentation-item {
            background: white;
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
            border: 1px solid rgba(0, 0, 0, 0.05);
            display: flex;
            flex-direction: column;
        }

        .documentation-item:hover {
            transform: translateY(-8px);
            box-shadow: 0 15px 35px rgba(67, 97, 238, 0.15);
        }

        .documentation-header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            color: white;
            padding: 25px;
            text-align: center;
        }

        .documentation-item h2 {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 0;
        }

        .documentation-content {
            padding: 25px;
            flex-grow: 1;
        }

        .price-list {
            list-style: none;
            margin-bottom: 25px;
        }

        .price-list li {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px dashed var(--light-gray);
            font-weight: 500;
            color: var(--dark);
        }

        .price-list li:last-child {
            border-bottom: none;
        }

        .price-list li span:last-child {
            color: var(--primary);
            font-weight: 600;
        }

        .action-button {
            display: block;
            text-align: center;
            padding: 15px;
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s ease;
            margin-top: auto;
            border: none;
            cursor: pointer;
            font-size: 1rem;
        }

        .action-button:hover {
            background: linear-gradient(135deg, var(--primary-dark) 0%, var(--secondary) 100%);
            box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
            transform: translateY(-2px);
        }

        .action-button i {
            margin-left: 8px;
        }

        /* Responsive Adjustments */
        @media (max-width: 768px) {
            h1 {
                font-size: 2rem;
            }
            
            .tagline {
                font-size: 1rem;
            }
            
            .feature-showcase, .documentation-grid {
                grid-template-columns: 1fr;
                padding: 20px;
            }
            
            .documentation-item {
                margin-bottom: 20px;
            }
            
            header {
                padding: 30px 20px;
            }
        }

        @media (max-width: 480px) {
            .container {
                border-radius: 12px;
            }
            
            h1 {
                font-size: 1.8rem;
            }
            
            .feature-box {
                padding: 20px;
            }
            
            .feature-icon {
                width: 60px;
                height: 60px;
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <div class="menu-container">
                <div class="menu-toggle" onclick="toggleMenu()">
                    <i class="fas fa-ellipsis-v"></i>
                </div>
                <nav id="dropdown-menu" class="dropdown-menu">
                    <a href="views.php?name=canva">
                        <i class="fas fa-palette"></i> Canva Pro
                    </a>
                    <a href="views.php?name=capcut">
                        <i class="fas fa-film"></i> CapCut Pro
                    </a>
                    <a href="views.php?name=youtube">
                        <i class="fab fa-youtube"></i> YouTube Premium
                    </a>
                </nav>
            </div>
            
            <h1>Unlock Your Digital Potential</h1>
            <p class="tagline">Access premium services at unbeatable prices with instant activation and 24/7 support. Elevate your digital experience today!</p>
        </header>

        <div class="feature-showcase">
            <div class="feature-box">
                <div class="feature-icon">
                    <i class="fas fa-bolt"></i>
                </div>
                <h3>Instant Activation</h3>
                <p>Immediate access to premium features right after your secure payment is processed.</p>
            </div>
            
            <div class="feature-box">
                <div class="feature-icon">
                    <i class="fas fa-tag"></i>
                </div>
                <h3>Best Price Guarantee</h3>
                <p>We offer the most competitive pricing with regular discounts and special offers.</p>
            </div>
            
            <div class="feature-box">
                <div class="feature-icon">
                    <i class="fas fa-lock"></i>
                </div>
                <h3>Secure Transactions</h3>
                <p>Bank-grade encryption ensures your payment information is always protected.</p>
            </div>
            
            <div class="feature-box">
                <div class="feature-icon">
                    <i class="fas fa-headset"></i>
                </div>
                <h3>24/7 Support</h3>
                <p>Our dedicated team is available round-the-clock to resolve any issues quickly.</p>
            </div>
            
            <div class="feature-box">
                <div class="feature-icon">
                    <i class="fas fa-sync-alt"></i>
                </div>
                <h3>Easy Renewals</h3>
                <p>Automated reminders and one-click renewal process for uninterrupted service.</p>
            </div>
            
            <div class="feature-box">
                <div class="feature-icon">
                    <i class="fas fa-crown"></i>
                </div>
                <h3>Premium Experience</h3>
                <p>Enjoy ad-free, full-featured access to all your favorite digital services.</p>
            </div>
        </div>

        <main class="documentation-grid">
            <div class="documentation-item">
                <div class="documentation-header">
                    <h2><i class="fab fa-youtube"></i> YouTube Premium</h2>
                </div>
                <div class="documentation-content">
                    <ul class="price-list">
                        <li><span>1 Month Subscription</span> <span>50 BDT</span></li>
                        <li><span>2 Months Subscription</span> <span>100 BDT</span></li>
                        <li><span>6 Months Subscription</span> <span>200 BDT</span></li>
                    </ul>
                    <a href="views.php?name=youtube" class="action-button">
                        Get YouTube Premium <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>

            <div class="documentation-item">
                <div class="documentation-header">
                    <h2><i class="fas fa-palette"></i> Canva Pro</h2>
                </div>
                <div class="documentation-content">
                    <ul class="price-list">
                        <li><span>1 Month Subscription</span> <span>70 BDT</span></li>
                        <li><span>2 Months Subscription</span> <span>140 BDT</span></li>
                        <li><span>6 Months Subscription</span> <span>280 BDT</span></li>
                    </ul>
                    <a href="views.php?name=canva" class="action-button">
                        Get Canva Pro <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>

            <div class="documentation-item">
                <div class="documentation-header">
                    <h2><i class="fas fa-film"></i> CapCut Pro</h2>
                </div>
                <div class="documentation-content">
                    <ul class="price-list">
                        <li><span>1 Month Subscription</span> <span>60 BDT</span></li>
                        <li><span>2 Months Subscription</span> <span>120 BDT</span></li>
                        <li><span>6 Months Subscription</span> <span>240 BDT</span></li>
                    </ul>
                    <a href="views.php?name=capcut" class="action-button">
                        Get CapCut Pro <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>
        </main>
    </div>

    <script>
        // Enhanced dropdown menu functionality
        function toggleMenu() {
            const dropdownMenu = document.getElementById('dropdown-menu');
            const menuToggle = document.querySelector('.menu-toggle');
            
            if (dropdownMenu.style.display === 'block') {
                dropdownMenu.style.display = 'none';
                menuToggle.style.transform = 'rotate(0deg)';
            } else {
                dropdownMenu.style.display = 'block';
                menuToggle.style.transform = 'rotate(90deg)';
            }
        }

        // Close menu when clicking outside
        document.addEventListener('click', function(event) {
            const dropdownMenu = document.getElementById('dropdown-menu');
            const menuToggle = document.querySelector('.menu-toggle');
            
            if (!event.target.closest('.menu-container') && dropdownMenu.style.display === 'block') {
                dropdownMenu.style.display = 'none';
                menuToggle.style.transform = 'rotate(0deg)';
            }
        });

        // Smooth scroll for better UX
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                
                document.querySelector(this.getAttribute('href')).scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });
    </script>
</body>
</html>
