<?php
// PHP কোডগুলো HTML-এর উপরে নিয়ে আসা হলো

$service_key = $_GET['name'] ?? null;
$data_file = 'data/app.json'; // ডেটা ফাইল পাথ
$order_file = 'data/order.json'; // অর্ডার ডেটা ফাইল পাথ

$service_data = []; // সার্ভিস ডেটা রাখার জন্য ভেরিয়েবল
$service_name = 'Unknown Service'; // ডিফল্ট সার্ভিস নাম

// ডেটা ফাইল আছে কিনা এবং সেটি রিড করা যাচ্ছে কিনা, তা যাচাই করা হচ্ছে
if (file_exists($data_file)) {
    $json_content = file_get_contents($data_file);
    $all_services = json_decode($json_content, true); // JSON ডেটা PHP অ্যাসোসিয়েটিভ অ্যারেতে রূপান্তর

    // যদি URL থেকে আসা 'name' প্যারামিটারটি থাকে এবং JSON ডেটার মধ্যে সেই সার্ভিসটি পাওয়া যায়
    if ($service_key && isset($all_services[$service_key])) {
        $service_data = $all_services[$service_key]; // নির্দিষ্ট সার্ভিসের ডেটা লোড করা হচ্ছে
        $service_name = $service_data['name']; // সার্ভিসের নাম
    }
}

// ফর্ম সাবমিশন হ্যান্ডলিং
$submission_message = '';
$message_type = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $transaction_id = $_POST['transaction_id'] ?? '';
    $amount = $_POST['amount'] ?? '';
    $last_payment_number = $_POST['last_payment_number'] ?? '';
    $email = $_POST['email'] ?? '';
    $submission_time = date('Y-m-d H:i:s'); // সাবমিশনের সময়

    // প্রাথমিক ইনপুট ভ্যালিডেশন
    if (empty($transaction_id) || empty($amount) || empty($last_payment_number) || empty($email)) {
        $submission_message = "Please fill in all required fields.";
        $message_type = "error";
    } else {
        // --- Save to JSON File Start ---
        $order_data = [
            'service_name' => $service_name,
            'transaction_id' => $transaction_id,
            'amount' => $amount,
            'last_payment_number' => $last_payment_number,
            'email' => $email,
            'submission_time' => $submission_time
        ];

        // Ensure data directory exists
        if (!is_dir('data')) {
            mkdir('data', 0777, true); // Create directory with full permissions
        }

        // Read existing data or initialize an empty array
        $existing_orders = [];
        if (file_exists($order_file)) {
            $current_content = file_get_contents($order_file);
            if ($current_content) {
                $decoded_content = json_decode($current_content, true);
                if (is_array($decoded_content)) {
                    $existing_orders = $decoded_content;
                }
            }
        }
        
        // Add new order to the array
        $existing_orders[] = $order_data;

        // Encode and save the updated array
        if (file_put_contents($order_file, json_encode($existing_orders, JSON_PRETTY_PRINT))) {
            $submission_message = "Thank you for your submission! Your request for **" . htmlspecialchars($service_name) . "** has been successfully received and saved. You will be contacted soon.";
            $message_type = "success";
        } else {
            error_log("Failed to save order to {$order_file}");
            $submission_message = "There was an issue processing your request and saving the data. Please try again or contact support directly.";
            $message_type = "error";
        }
        // --- Save to JSON File End ---
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($service_name) ? htmlspecialchars($service_name) . " | Premium Service Hub" : "Service Details | Premium Service Hub"; ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #3f37c9;
            --accent: #4895ef;
            --dark: #1f2937;
            --light: #f8f9fa;
            --success: #4cc9f0; /* Changed to match previous success color */
            --warning: #f8961e;
            --danger: #f72585;
            --gray: #6b7280;
            --light-gray: #e5e7eb;
            --card-bg: #ffffff;
        }

        /* Base Styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
            color: var(--dark);
            line-height: 1.6;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
            padding: 40px 20px;
        }

        .container {
            background-color: white;
            border-radius: 16px;
            box-shadow: 0 12px 30px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 900px;
            overflow: hidden;
            position: relative;
        }

        /* Back Button */
        .back-button {
            position: absolute;
            top: 25px;
            left: 25px;
            font-size: 1rem;
            color: var(--primary);
            text-decoration: none;
            padding: 10px 15px;
            border-radius: 8px;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
            background-color: rgba(67, 97, 238, 0.1);
            border: 1px solid rgba(67, 97, 238, 0.2);
            z-index: 10;
        }

        .back-button:hover {
            background-color: var(--primary);
            color: white;
            transform: translateX(-3px);
        }

        /* Header Section */
        .service-header {
            text-align: center;
            padding: 60px 20px 30px;
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            color: white;
            position: relative;
            overflow: hidden;
        }

        .service-header::before {
            content: "";
            position: absolute;
            top: -50px;
            right: -50px;
            width: 200px;
            height: 200px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }

        .service-header::after {
            content: "";
            position: absolute;
            bottom: -80px;
            left: -50px;
            width: 250px;
            height: 250px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 50%;
        }

        h1 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 15px;
            position: relative;
            z-index: 2;
        }

        .tagline {
            font-size: 1.1rem;
            max-width: 700px;
            margin: 0 auto 10px;
            opacity: 0.9;
            font-weight: 300;
            position: relative;
            z-index: 2;
        }

        .service-icon {
            font-size: 3rem;
            margin-bottom: 20px;
            position: relative;
            z-index: 2;
            color: white;
        }

        /* Service Details Grid */
        .service-details {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 25px;
            padding: 40px;
        }

        .detail-box {
            background: var(--card-bg);
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
            border: 1px solid rgba(0, 0, 0, 0.05);
            position: relative;
            overflow: hidden;
        }

        .detail-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(67, 97, 238, 0.1);
        }

        .detail-box::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 5px;
            height: 100%;
            background: linear-gradient(to bottom, var(--primary), var(--accent));
        }

        .detail-box h2 {
            font-size: 1.3rem;
            color: var(--dark);
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid var(--light-gray);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .detail-box h2 i {
            color: var(--primary);
        }

        .detail-box ul {
            list-style: none;
        }

        .detail-box li {
            padding: 8px 0;
            position: relative;
            padding-left: 30px;
            color: var(--gray);
            font-size: 0.95rem;
        }

        .detail-box li i {
            position: absolute;
            left: 0;
            top: 10px;
            color: var(--primary);
            font-size: 0.9rem;
        }

        /* Pricing Box Specific Styles */
        .detail-box.pricing p {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px dashed var(--light-gray);
            font-size: 1rem;
        }

        .detail-box.pricing p:last-child {
            border-bottom: none;
        }

        .detail-box.pricing span:last-child {
            color: var(--primary);
            font-weight: 600;
        }

        /* Delivery & Validity Section */
        .delivery-validity-section {
            background: linear-gradient(135deg, rgba(67, 97, 238, 0.05) 0%, rgba(72, 149, 239, 0.05) 100%);
            padding: 30px 40px;
            margin: 0 40px 40px;
            border-radius: 12px;
            text-align: center;
            border: 1px solid rgba(67, 97, 238, 0.1);
        }

        .delivery-validity-section h2 {
            font-size: 1.5rem;
            color: var(--primary);
            margin-bottom: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
        }

        .delivery-validity-section p {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-bottom: 15px;
            font-size: 1rem;
            color: var(--gray);
        }

        .delivery-validity-section p strong {
            color: var(--dark);
            font-weight: 500;
        }

        /* Form Section */
        .form-section {
            padding: 0 40px 40px;
        }

        .form-section h2 {
            font-size: 1.8rem;
            color: var(--dark);
            margin-bottom: 30px;
            text-align: center;
            position: relative;
            padding-bottom: 15px;
        }

        .form-section h2::after {
            content: "";
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 3px;
            background: linear-gradient(to right, var(--primary), var(--accent));
            border-radius: 3px;
        }

        .form-group {
            margin-bottom: 25px;
            position: relative;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: var(--dark);
            font-weight: 500;
            font-size: 0.95rem;
        }

        .form-group .input-container {
            position: relative;
        }

        .form-group .input-container i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--gray);
            font-size: 1rem;
        }

        .form-group input {
            width: 100%;
            padding: 12px 15px 12px 45px;
            border: 1px solid var(--light-gray);
            border-radius: 8px;
            font-size: 0.95rem;
            transition: all 0.3s ease;
            background-color: var(--light);
        }

        .form-group input:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
            outline: none;
            background-color: white;
        }

        .required-label::after {
            content: " *";
            color: var(--danger);
        }

        .submit-button {
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            color: white;
            padding: 15px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1rem;
            width: 100%;
            margin-top: 20px;
            transition: all 0.3s ease;
            font-weight: 600;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
            box-shadow: 0 4px 15px rgba(67, 97, 238, 0.3);
        }

        .submit-button:hover {
            background: linear-gradient(135deg, var(--primary-dark) 0%, var(--secondary) 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(67, 97, 238, 0.4);
        }
        
        .submit-button.disabled {
            background: #cccccc;
            cursor: not-allowed;
            opacity: 0.7;
            box-shadow: none;
        }
        .submit-button.disabled:hover {
            transform: translateY(0);
            box-shadow: none;
        }


        /* Message Styles */
        .message {
            padding: 20px;
            border-radius: 8px;
            margin: 20px 40px;
            font-size: 1rem;
            text-align: center;
            position: relative;
            overflow: hidden;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .message::before {
            content: "";
            position: absolute;
            left: 0;
            top: 0;
            width: 5px;
            height: 100%;
        }
        
        .message i {
            margin-top: 10px; /* Space between text and icon */
            font-size: 2rem;
        }

        .message.success {
            background-color: rgba(76, 201, 240, 0.1);
            color: #0e7490;
            border: 1px solid rgba(76, 201, 240, 0.3);
        }

        .message.success::before {
            background-color: var(--success);
        }
        .message.success i {
            color: var(--success);
        }


        .message.error {
            background-color: rgba(247, 37, 133, 0.1);
            color: #be123c;
            border: 1px solid rgba(247, 37, 133, 0.3);
        }

        .message.error::before {
            background-color: var(--danger);
        }
        .message.error i {
            color: var(--danger);
        }


        /* Unknown Product Message */
        .unknown-product-message {
            padding: 60px 40px;
            text-align: center;
            background-color: rgba(248, 150, 30, 0.1);
            border: 1px solid rgba(248, 150, 30, 0.3);
            border-radius: 12px;
            margin: 40px;
            position: relative;
            overflow: hidden;
        }

        .unknown-product-message::before {
            content: "";
            position: absolute;
            left: 0;
            top: 0;
            width: 5px;
            height: 100%;
            background-color: var(--warning);
        }

        .unknown-product-message h1 {
            color: var(--warning);
            margin-bottom: 20px;
            font-size: 2rem;
        }

        .unknown-product-message h1 i {
            margin-right: 10px;
            font-size: 2rem;
        }

        .unknown-product-message p {
            color: var(--gray);
            font-size: 1.1rem;
            max-width: 600px;
            margin: 0 auto;
        }

        /* Responsive Adjustments */
        @media (max-width: 768px) {
            .container {
                padding: 0;
            }
            
            .service-header {
                padding: 50px 20px 25px;
            }
            
            h1 {
                font-size: 2rem;
            }
            
            .service-details, .delivery-validity-section, .form-section {
                padding: 25px;
            }
            
            .delivery-validity-section {
                margin: 0 25px 25px;
            }
            
            .message {
                margin: 20px 25px;
            }
        }

        @media (max-width: 480px) {
            .back-button {
                top: 15px;
                left: 15px;
                padding: 8px 12px;
                font-size: 0.9rem;
            }
            
            .service-header {
                padding: 60px 15px 20px;
            }
            
            h1 {
                font-size: 1.8rem;
            }
            
            .tagline {
                font-size: 1rem;
            }
            
            .service-details {
                grid-template-columns: 1fr;
                gap: 20px;
            }
            
            .form-group input {
                padding: 12px 15px 12px 40px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="index.php" class="back-button">
            <i class="fas fa-arrow-left"></i> Back to Services
        </a>

        <?php if (!empty($submission_message)): ?>
            <div class="message <?php echo htmlspecialchars($message_type); ?>">
                <?php echo $submission_message; ?>
                <?php if ($message_type == 'success'): ?>
                    <i class="fas fa-check-circle"></i>
                <?php elseif ($message_type == 'error'): ?>
                    <i class="fas fa-times-circle"></i>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if (empty($service_data)): ?>
            <div class="unknown-product-message">
                <h1><i class="fas fa-exclamation-triangle"></i> Unknown Product</h1>
                <p>The requested product could not be found. Please return to the service selection page and try again.</p>
                <div style="margin-top: 30px;">
                    <a href="index.php" class="back-button">
                        <i class="fas fa-arrow-left"></i> Back to Services
                    </a>
                </div>
            </div>
        <?php else: ?>
            <div class="service-header">
                <div class="service-icon">
                    <?php if ($service_key == 'youtube'): ?>
                        <i class="fab fa-youtube"></i>
                    <?php elseif ($service_key == 'canva'): ?>
                        <i class="fas fa-palette"></i>
                    <?php elseif ($service_key == 'capcut'): ?>
                        <i class="fas fa-film"></i>
                    <?php else: ?>
                        <i class="fas fa-crown"></i>
                    <?php endif; ?>
                </div>
                <h1><?php echo htmlspecialchars($service_name); ?></h1>
                <p class="tagline">Premium subscription details and activation</p>
            </div>

            <div class="service-details">
                <div class="detail-box pricing">
                    <h2><i class="fas fa-tags"></i> Pricing Plans</h2>
                    <?php foreach ($service_data['pricing'] as $type => $price): ?>
                        <p>
                            <span><?php echo ucfirst($type); ?> Subscription</span>
                            <span><?php echo htmlspecialchars($price); ?></span>
                        </p>
                    <?php endforeach; ?>
                </div>

                <div class="detail-box features">
                    <h2><i class="fas fa-star"></i> Key Features</h2>
                    <ul>
                        <?php foreach ($service_data['features'] as $feature): ?>
                            <li>
                                <i class="fas fa-check"></i>
                                <?php echo htmlspecialchars($feature); ?>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>

                <div class="detail-box versions">
                    <h2><i class="fas fa-code-branch"></i> Available Versions</h2>
                    <ul>
                        <?php foreach ($service_data['versions'] as $version): ?>
                            <li>
                                <i class="fas fa-caret-right"></i>
                                <?php echo htmlspecialchars($version); ?>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>

                <div class="detail-box platforms">
                    <h2><i class="fas fa-laptop"></i> Supported Platforms</h2>
                    <ul>
                        <?php foreach ($service_data['platforms'] as $platform): ?>
                            <li>
                                <i class="fas fa-check-circle"></i>
                                <?php echo htmlspecialchars($platform); ?>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>

            <div class="delivery-validity-section">
                <h2><i class="fas fa-shipping-fast"></i> Delivery & Guarantee</h2>
                <p>
                    <strong>Delivery Method:</strong> 
                    <span><?php echo htmlspecialchars($service_data['delivery'] ?? 'Instant digital delivery'); ?></span>
                </p>
                <p>
                    <strong>Service Guarantee:</strong> 
                    <span><?php echo htmlspecialchars($service_data['validity'] ?? 'Full validity period guaranteed'); ?></span>
                </p>
            </div>

            <div class="form-section">
                <h2><i class="fas fa-paper-plane"></i> Activation Request</h2>
                <form method="POST">
                    <div class="form-group">
                        <label for="transaction-id" class="required-label">Transaction ID</label>
                        <div class="input-container">
                            <i class="fas fa-receipt"></i>
                            <input type="text" id="transaction-id" name="transaction_id" placeholder="Enter your transaction ID" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="amount" class="required-label">Amount Paid</label>
                        <div class="input-container">
                            <i class="fas fa-money-bill-wave"></i>
                            <input type="number" id="amount" name="amount" placeholder="Enter amount in BDT" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="last-payment-number" class="required-label">Last 4 Digits of Payment Number</label>
                        <div class="input-container">
                            <i class="fas fa-credit-card"></i>
                            <input type="text" id="last-payment-number" name="last_payment_number" 
                                   placeholder="Last 4 digits" maxlength="4" pattern="\d{4}" 
                                   title="Please enter the last 4 digits of your payment method" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="email" class="required-label">Email Address</label>
                        <div class="input-container">
                            <i class="fas fa-envelope"></i>
                            <input type="email" id="email" name="email" placeholder="Your email address" required>
                        </div>
                    </div>

                    <button type="submit" class="submit-button" id="submitButton">
                        <i class="fas fa-paper-plane"></i> Submit Activation Request
                    </button>
                </form>
            </div>
        <?php endif; ?>
    </div>

    <script>
        // Enhanced form validation and time limit using Local Storage
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.querySelector('form');
            const submitButton = document.getElementById('submitButton');
            const LAST_SUBMISSION_KEY = 'lastOrderSubmissionTime';
            const COOLDOWN_HOURS = 1; // 1 hour cooldown

            function checkCooldown() {
                const lastSubmissionTime = localStorage.getItem(LAST_SUBMISSION_KEY);
                if (lastSubmissionTime) {
                    const now = new Date();
                    const lastSubmitDate = new Date(parseInt(lastSubmissionTime));
                    const hoursPassed = (now - lastSubmitDate) / (1000 * 60 * 60); // Milliseconds to hours

                    if (hoursPassed < COOLDOWN_HOURS) {
                        const remainingMinutes = Math.ceil((COOLDOWN_HOURS - hoursPassed) * 60);
                        submitButton.disabled = true;
                        submitButton.classList.add('disabled');
                        submitButton.innerHTML = `<i class="fas fa-hourglass-half"></i> Please wait ${remainingMinutes} min`;
                        return false;
                    }
                }
                submitButton.disabled = false;
                submitButton.classList.remove('disabled');
                submitButton.innerHTML = `<i class="fas fa-paper-plane"></i> Submit Activation Request`;
                return true;
            }

            if (form) {
                // Initial check when page loads
                checkCooldown();

                form.addEventListener('submit', function(e) {
                    const paymentNumber = document.getElementById('last-payment-number');
                    if (paymentNumber && !/^\d{4}$/.test(paymentNumber.value)) {
                        alert('Please enter exactly 4 digits for payment number');
                        e.preventDefault();
                        paymentNumber.focus();
                        return; // Stop form submission
                    }

                    if (!checkCooldown()) {
                        e.preventDefault(); // Prevent submission if still on cooldown
                        alert('You can only submit an order once every ' + COOLDOWN_HOURS + ' hour(s). Please wait.');
                        return; // Stop form submission
                    }

                    // If all checks pass, set the last submission time
                    localStorage.setItem(LAST_SUBMISSION_KEY, new Date().getTime());
                });
            }
            
            // Add animation to cards when they come into view
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = 1;
                        entry.target.style.transform = 'translateY(0)';
                    }
                });
            }, { threshold: 0.1 });
            
            document.querySelectorAll('.detail-box').forEach(box => {
                box.style.opacity = 0;
                box.style.transform = 'translateY(20px)';
                box.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                observer.observe(box);
            });

            // Re-check cooldown every minute to update the button text
            setInterval(checkCooldown, 60 * 1000); // Check every minute
        });
    </script>
</body>
</html>
